/* AstroController.h
 *
 * Copyright (C) 1999-2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  2003-03-23
 * Modified: 2004-08-21
 */

#ifndef VHF_H_PREFASTROCONTROLLER
#define VHF_H_PREFASTROCONTROLLER

#include <AppKit/AppKit.h>
#include "../../Cenon/PreferencesPanel.subproj/PreferencesMethods.h"

#define Prefs_ShowRetrograde	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowRetrograde"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowHousePosition	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowHousePosition"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowHouseSize	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowHouseSize"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowHouseMaxima	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowHouseMaxima"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_LocalScale	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroLocalScale"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_HouseDegrees	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroHouseDegrees"] isEqual:@"YES"]) ? YES : NO )
/*#define Prefs_ShowWaves		( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowWaves"] isEqual:@"YES"]) ? YES : NO )*/
#define Prefs_Topocentric	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroTopocentricPosition"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowDeclination	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowDeclination"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ACFix		( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroACFix"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_MeanNodes		( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroMeanNodes"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_DegreesMinutes	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroDegreesMinutes"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_Colorful		( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroColorful"] isEqual:@"YES"]) ? YES : NO )

#define Prefs_BGColor		vhfRGBColorFromString([[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroBGColor"])
#define Prefs_DateFormat	[[NSUserDefaults standardUserDefaults] objectForKey:@"astroDateFormat"]
#define Prefs_AstroFont		[[NSUserDefaults standardUserDefaults] objectForKey:@"astroFont"]
#define Prefs_Objects		[[NSUserDefaults standardUserDefaults] objectForKey:@"astroObjects"]
#define Prefs_Nodes		[[NSUserDefaults standardUserDefaults] objectForKey:@"astroNodes"]

/* switches in switchMatrix */
#define SWITCH_SHOWRETROGRADE	0
#define SWITCH_SHOWHOUSEPOS	1
#define SWITCH_SHOWHOUSESIZE	2	// display size of house
#define SWITCH_SHOWHOUSEMAXIMA	3	// mark maxima of house
#define SWITCH_LOCALSCALE	4	// topocentric degree scale
#define SWITCH_HOUSEDEGREES	5	// planet positions relative houses
//#define SWITCH_SHOWWAVES	6
#define SWITCH_TOPOCENTRIC	6	// topocentric planet positions (at location on earth)
#define SWITCH_SHOWDECLINATION	7
#define SWITCH_ACFIX		8
#define SWITCH_MEANNODES	9
#define SWITCH_DEGREESMINUTES	10
#define SWITCH_COLORFUL		11	// use colors for house tips etc.

/* objects */
#define OBJECTS_1		[NSArray arrayWithObjects: \
                                  @"Sun", @"Moon", @"Mercury", @"Venus", @"Mars", \
                                  @"Jupiter", @"Saturn", @"Uranus", @"Neptune", @"Pluto", nil]
#define OBJECTS_2		[NSArray arrayWithObjects: \
                                  @"Node", @"True Node", @"Apogee", @"True Apogee", \
                                  @"Chiron", @"Pholus", @"Ceres", @"Pallas", @"Juno", @"Vesta", nil]

@interface AstroController:NSObject <PreferencesMethods>
{
    id box;

    id bgColorWell;	// color well for background color
    id datePopup;	// the date format popup
    id fontPopup;	// the font popup
    id switchMatrix;	// the switches
    id object1Switches;	// planets
    id nodeSwitches;	// planet nodes
    id object2Switches;	// moon nodes and asteroids
}

- (void)set:sender;
//- (void)setColor:sender;

@end

#endif // VHF_H_PREFASTROCONTROLLER
