/* AstroMandala.h
 * Fractal Astrological Mandalas
 *
 * Copyright (C) 2003-2005 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2003-11-23
 * modified: 2005-08-24
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTROMANDALA
#define VHF_H_ASTROMANDALA

#include <AppKit/AppKit.h>
#include "DocViewAstro.h"

#define MANDALA_PREFIX	@"Mandala"		// the prefix of the filename of mandalas

/* mapping */
typedef enum
{
    MAP_CIRCULAR  = 0,
    MAP_CARTESIAN = 1
} MandalaMapping;

/* mandala types */
typedef enum
{   TYPE_FRACTAL_SPIRAL = 0,	// Fractal Spiral with fixed octave angle
    TYPE_FRACTAL_LEAF   = 1,	// Fractal Leafs
    TYPE_DOTS           = 2
} MandalaType;

/* mandala components */
typedef enum
{   COMPONENT_ZODIAC    = 1,	// ecliptic
    COMPONENT_PLANETS   = 2,	// planets
    COMPONENT_HOUSES    = 4,	// topocentric cycle
    COMPONENT_COMPOSITE = 8	// add composite components (Transits)
} MandalaComponents;

@interface AstroMandala:NSObject
{
    DocView		*view;			// where to draw
    id			ephemeris;

    NSArray		*planets;
    NSCalendarDate	*utc;
    float		lat, lon;
    NSDictionary	*degreeDict;

    /* dimensions (from template of mask) */
    NSRect		bounds;			// image area

    /* parameter */
    MandalaType		mandalaType;		// kind of mandala
    int			components;		// components of mandala
    int			dividersFrom, dividersTo;
    NSColor		*bgColor;		// background color
    int			dimensionX, dimensionY;
    int			recursions;		// number of recursions
    int			octaveAngle;		// angle for one octave
    int			maxMapDivider;

    float		planetDeg[20];		// planet representation in degrees of unit cycle
    MandalaMapping	mapping;		// kind of mapping (circular, cartesian)
}

+ (id)mandalaWithView:(DocView*)aView;
- (id)initWithView:(DocView*)aView;
- (void)setView:(id)newView;

- (void)setFeatures:(NSDictionary*)features;

- (void)mandala:(NSCalendarDate*)gmt
      longitude:(float)longitude latitude:(float)latitude city:(NSString*)city
          title:(NSString*)title;
@end

#endif // VHF_H_ASTROMANDALA
