/* APMandala.m
 * Controls the generation of fractal mandalas
 *
 * Copyright (C) 2003-2005 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  2003-11-23
 * Modified: 2005-08-25
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include <VHFShared/vhfCommonFunctions.h>
#include "../Cenon/App.h"
//#include "../Cenon/locations.h"
#include "../Cenon/messages.h"
#include "../Cenon/functions.h"
#include "AstroPanel.h"
#include "APMandala.h"
#include "APChart.h"
#include "../AstroMandala.h"
#include "../astroLocations.h"
#include "../EventManager.h"
#include "../AstroPrincipal.h"

@interface APMandala(PrivateMethods)
@end

@implementation APMandala

- init
{
    [self setDelegate:self];
    return [super init];
}

- (NSMutableDictionary*)features
{   NSMutableDictionary	*dict = [NSMutableDictionary dictionary];
    int			mapping = MAP_CIRCULAR, i, components = 0;

    [dict setObject:[NSNumber numberWithInt:[typePopup indexOfSelectedItem]]
             forKey:@"mandalaType"];

    /* divider range */
    [dict setObject:[dividerFromField stringValue] forKey:@"dividersFrom"];
    [dict setObject:[dividerToField   stringValue] forKey:@"dividersTo"];

    /* background color */
    [dict setObject:[bgColorWell color] forKey:@"bgColor"];

    /* components: tag contains the binary index */
    for (i=0; i<[componentSwitches numberOfRows]; i++)
        if ([[componentSwitches cellAtRow:i column:0] state])
            components |= [[componentSwitches cellAtRow:i column:0] tag];
    [dict setObject:[NSNumber numberWithInt:components] forKey:@"components"];

    /* fields */
    [dict setObject:[recursionsField  stringValue] forKey:@"recursions"];
    [dict setObject:[octaveAngleField stringValue] forKey:@"octaveAngle"];
    [dict setObject:[mapDividerField  stringValue] forKey:@"maxMapDivider"];

    /* radial/axial switches */
    if ([[dimensionSwitches cellAtRow:DIM_X column:0] state])
        [dict setObject:@"1" forKey:@"dimensionX"];
    if ([[dimensionSwitches cellAtRow:DIM_Y column:0] state])
        [dict setObject:@"1" forKey:@"dimensionY"];

    /* old, really needed ??? */
    if ([mappingPopup indexOfSelectedItem] == MAP_CARTESIAN)
        mapping = MAP_CARTESIAN;
    [dict setObject:[NSNumber numberWithInt:mapping] forKey:@"mapping"];

    return dict;
}

/* start calculation of chart
 */
- (void)set:(id)sender
{   NSCalendarDate	*utc;
    float		lat, lon;
    Document		*doc = [(App*)NSApp currentDocument];
    DocView		*view = [doc documentView];
    APChart		*apChart = [[Astro_Principal astroPanel] windowAt:AP_CHART];

    lat = [apChart latitude];
    lon = [apChart longitude];
    utc = [apChart date];

    if (!astroMandala && view && [[doc name] hasPrefix:MANDALA_PREFIX] )
        astroMandala = [[AstroMandala mandalaWithView:view] retain];
    else if (astroMandala && view && [[doc name] hasPrefix:MANDALA_PREFIX] )
        [astroMandala setView:view];

    [astroMandala setFeatures:[self features]];
    [astroMandala mandala:utc longitude:lon latitude:lat city:[apChart city] title:[apChart title]];
}

- (id)astroMandala
{
    return astroMandala;
}

/*
 * mandala methods
 */



/*
 * notifications
 */



/* created:  1993-07-22
 * modified: 2003-06-22
 */
- (void)dealloc
{
    [super dealloc];
}

@end
