/* TopocentricCycle.h
 * Topocentric houses and related functions
 *
 * Copyright (C) 1999-2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2003-08-11
 * modified: 2004-07-13
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_TOPOCENTRIC
#define VHF_H_TOPOCENTRIC

typedef struct _TopocentricSettings
{
    int		mon;	// Month
    int		day;	// Day
    int		yea;	// Year
    double	tim;	// Time in hours

    double	lon;	// Longitude
    double	lat;	// Latitude

    double	MC;	// Midheaven at chart time
    double	AC;	// Ascendant at chart time
    double	RA;	// Right ascension at time
    double	OB;	// Obliquity of ecliptic
} TOPO;

@interface TopocentricCycle:NSObject
{
    TOPO	topo;
}

+ (TopocentricCycle*)topocentricCycleAtDate:(NSCalendarDate*)utc latitude:(float)lat longitude:(float)lon;
- (id)initWithDate:(NSCalendarDate*)utc latitude:(float)lat longitude:(float)lon;
- (void)setDate:(NSCalendarDate*)utc latitude:(float)lat longitude:(float)lon;
- (void)setDate:(int)yymmdd time:(int)hhmm latitude:(float)lat longitude:(float)lon;
- (void)setLatitude:(float)lat longitude:(float)lon;	// only updates lat/lon

- (double)ac;
- (double)mc;
- (double*)houses:(int)cnt;
- (double*)housesAtDate:(NSCalendarDate*)utc latitude:(float)lat longitude:(float)lon number:(int)houseCnt;
- (double)eclipticDegree:(double)topocentricDeg;
- (double)topocentricDegree:(double)eclipticDeg;

- (BOOL)testAtDate:(NSCalendarDate*)utc latitude:(float)lat longitude:(float)lon;

@end

#endif // VHF_H_TOPOCENTRIC
