/* TimeZoneManager.m
 * controller class and files owner of the TimeZonePanel
 *
 * Copyright (C) 2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2004-10-06
 * modified: 2004-10-06
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include "TimeZoneManager.h"
#include "../Cenon/VHFShared/VHFDictionaryAdditions.h"
#include "../Cenon/App.h"
#include "../Cenon/functions.h"
#include "../Cenon/messages.h"
#include "astroMessages.h"
#include "AstroPrincipal.h"
#include "Astro.bproj/AstroController.h"

/* implement missing class method in NSTimeZone for OpenStep */
#if !defined(GNUSTEP_BASE_VERSION) && !defined(__APPLE__)	// OpenStep 4.2
@interface NSTimeZone(VHFTimeZoneAdditions)
+ (NSArray*)knownTimeZoneNames;
@end
@implementation NSTimeZone(VHFTimeZoneAdditions)
+ (NSArray*)knownTimeZoneNames
{   static NSArray	*names = nil;

    if (!names)
    {   NSData		*data;
        NSDictionary	*dict;
        NSBundle	*bundle = [NSBundle bundleForClass:[NSTimeZone class]];
        NSString	*path = [bundle pathForResource:@"TimeZoneInfo" ofType:nil];

        path = [path stringByAppendingPathComponent:@"TimeZones.splist"];
        data = [NSData dataWithContentsOfFile:path];
        dict = [NSDeserializer deserializePropertyListFromData:data mutableContainers:NO];
        names = [[dict allKeys] retain];
    }
    return names;
}
@end
#endif

#if defined(GNUSTEP_BASE_VERSION) //&& GNUSTEP_BASE_VERSION <= "1.10.0"
@interface NSTimeZone(VHFTimeZoneAdditions)
+ (NSArray*)knownTimeZoneNames;
@end
@implementation NSTimeZone(VHFTimeZoneAdditions)
+ (NSArray*) knownTimeZoneNames
{   static NSArray *namesArray = nil;
    int i;
    id temp_array;
    NSArray *regionsArray, *array;

    if (namesArray != nil)
        return namesArray;

    temp_array = [NSMutableArray array];
    regionsArray = [NSTimeZone timeZoneArray];

    for (i = 0; i < [regionsArray count]; i++)
    {
        array = [regionsArray objectAtIndex:i];
        [temp_array addObjectsFromArray: array];
    }

    namesArray = [[NSArray alloc] initWithArray: temp_array];
    return namesArray;
}
@end
#endif


@interface TimeZoneManager(PrivateMethods)
- (void)getRegions;
@end

@implementation TimeZoneManager

/* 
 */
- (id)init
{
    [super init];
    return self;
}

/* load interface file and display panel
 */
- (void)showPanel:sender
{
    if (!timeZonePanel)
    {   NSBundle	*bundle = [NSBundle bundleForClass:[TimeZoneManager class]];

        /* load time zone panel */
        if ( ![bundle loadNibFile:@"TimeZonePanel"
                externalNameTable:[NSDictionary dictionaryWithObject:self forKey:@"NSOwner"]
                         withZone:[self zone]] )
            NSLog(@"Cannot load TimeZonePanel interface file");
        [timeZonePanel setFrameUsingName:@"TimeZonePanel"];
        [timeZonePanel setFrameAutosaveName:@"TimeZonePanel"];

        [timeZoneBrowser setDelegate:self];
        [timeZoneBrowser setTarget:self];
        [timeZoneBrowser setAction:@selector(doClick:)];
        [self getRegions];
        [timeZoneBrowser loadColumnZero];
    }
    [timeZonePanel makeKeyAndOrderFront:sender];
}


- (void)getRegions
{   NSArray	*timeZoneArray = [NSTimeZone knownTimeZoneNames];
    int		i;

    [regions release];
    regions = [NSMutableArray new];
    for (i=0; i<[timeZoneArray count]; i++)
    {   NSString	*name = [timeZoneArray objectAtIndex:i], *region;
        NSRange		range;

        range = [name rangeOfString:@"/"];
        if (!range.length)
            region = name;
        else
            region = [name substringToIndex:range.location];
        if (![regions containsObject:region])
            [regions addObject:region];
    }
    [regions sortUsingSelector:@selector(compare:)];
}
- (void)getZonesForRegion:(NSString*)region
{   NSArray	*timeZoneArray = [NSTimeZone knownTimeZoneNames];
    int		i;
    NSString	*selectedRegion = [regions objectAtIndex:[timeZoneBrowser selectedRowInColumn:0]];

    [zones release];
    zones = [NSMutableArray new];
    for (i=0; i<[timeZoneArray count]; i++)
    {   NSString	*name = [timeZoneArray objectAtIndex:i], *zone;
        NSRange		range;

        range = [name rangeOfString:@"/"];
        if (!range.length)
            continue;
        region = [name substringToIndex:range.location];
        if ([region isEqual:selectedRegion])
        {   zone = [name substringFromIndex:range.location+1];
            [zones addObject:zone];
        }
    }
    [zones sortUsingSelector:@selector(compare:)];
}

/* delegate methods
 */
- (int)browser:(NSBrowser*)sender numberOfRowsInColumn:(int)column
{
    switch (column)
    {
        case 0: return [regions count];
        case 1: return [zones count];
    }
    return 0;
}

-(void)browser:(NSBrowser*)sender willDisplayCell:(id)cell atRow:(int)row column:(int)column
{   NSString	*name;

    switch (column)
    {
        case 0:
            name = [regions objectAtIndex:row];
            [cell setStringValue:name];
            [cell setLeaf:NO];
            break;
        case 1:
            [cell setStringValue:[zones objectAtIndex:row]];
            [cell setLeaf:YES];
    }
    [cell setLoaded:YES];
}

- (void)doClick:sender
{   int	regionIx = [timeZoneBrowser selectedRowInColumn:0];
    int	zoneIx   = [timeZoneBrowser selectedRowInColumn:1];

    if (zoneIx < 0)
    {
        [self getZonesForRegion:[regions objectAtIndex:regionIx]];
        [timeZoneBrowser reloadColumn:1];
        //[timeZoneBrowser selectRow:[timeZoneBrowser selectedRowInColumn:0] inColumn:0];
    }
}

/* set selection via notification
 */
- (void)set:sender
{   int		regionIx = [timeZoneBrowser selectedRowInColumn:0];
    int		zoneIx   = [timeZoneBrowser selectedRowInColumn:1];
    NSString	*name;
    NSTimeZone	*timeZone;

    if (regionIx < 0 || (zoneIx < 0 && [zones count]))
        return;
    if (zoneIx < 0 && ![zones count])
        name = [regions objectAtIndex:regionIx];
    else
        name = [NSString stringWithFormat:@"%@/%@", [regions objectAtIndex:regionIx],
                                                    [zones   objectAtIndex:zoneIx]];
    timeZone = [NSTimeZone timeZoneWithName: name];
    [[NSNotificationCenter defaultCenter] postNotificationName:AstroTimeZoneChanged
                                                        object:timeZone userInfo:nil];
    //NSLog(@"%@", [timeZone timeZoneName]);
}

- (void)dealloc
{
    [regions release];
    [zones release];
    [super dealloc];
}

@end
