/* AspectLines.h
 * This calculates the traditional aspect lines
 *
 * Copyright (C) 2006 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2006-04-11
 * modified: 2006-05-01
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Ammerbuch, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASPECTLINES
#define VHF_H_ASPECTLINES

#include <AppKit/AppKit.h>

#define MAX_DIVIDER	50

@interface AspectLines:NSObject
{
    int		divider[MAX_DIVIDER];	// integer dividers
    int		dividerCnt;
    NSArray	*dividerColors;		// colors of dividers

    BOOL	showMirrors;		// whether to display mirror aspects
    BOOL	showStrengthOfOrb;	// whether to show the strength of orb
    BOOL	showColoredDividers;	// whether to use colors for aspects
    NSArray	*colors;		// aspect colors

    float	radius;			// the radius of the circle we operate
    float	saturation;		// color saturation
    float	orb;			// relative orb (factor of aspect) [0, 1.0], default = 5%
    float	maxOrbWidth;		// maximum line width for showing strength of orb

    double	*objects;		// the degrees we work with
    int		objectCnt;
}

+ (id)sharedInstance;

- (void)setDividersFromString:(NSString*)divStr;
- (void)setDisplayMirrors:(BOOL)mirrorFlag;

- (void)setStrengthOfOrb:(BOOL)flag;
- (void)setColoredDividers:(BOOL)flag;
- (void)setColorSaturation:(float)s;

- (void)setRadius:(float)radius;
- (void)setObjects:(double*)newObjs cnt:(int)oCnt;
- (void)setOrb:(float)newOrb;

- (VGroup*)calculateAtCenter:(NSPoint)center;

@end

#endif // VHF_H_ASPECTLINES
