/* colorFunctions.h
 * color converting, filtering, etc.
 *
 * Copyright (C) 2003-2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2003-08-03
 * modified: 2004-06-02
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_COLORFUNCTIONS
#define VHF_H_COLORFUNCTIONS

/* Hue, Saturation, Intensity */
typedef struct
{
    float	h;					// hue        [0.0, 1.0]
    float	s;					// saturation [0.0, 1.0] (passive component)
    float	i;					// intensity  [0.0, 1.0] (active component, eg. light)
}HSI;
static __inline__ HSI VHFMakeHSI(float h, float s, float i)
{   HSI	hsi;
    hsi.h = h; hsi.s = s; hsi.i = i;
    return hsi;
}

/* Red, Green, Blue */
typedef struct
{
    float	r, g, b;				// red, green, blue [0.0, 1.0]
}RGB;
static __inline__ RGB VHFMakeRGB(float r, float g, float b)
{   RGB	rgb;
    rgb.r = r; rgb.g = g; rgb.b = b;
    return rgb;
}


RGB RGBFromHSI(HSI hsi);
HSI HSIFromRGB(RGB rgb);

HSI filterColors(int count, ...);
HSI addColors(int count, ...);

#endif // VHF_H_COLORFUNCTIONS
