/* APMandala.m
 * Controls the chart generation
 *
 * Copyright (C) 2003-2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  2003-11-23
 * Modified: 2004-06-03
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include <VHFShared/vhfCommonFunctions.h>
#include "../Cenon/App.h"
//#include "../Cenon/locations.h"
#include "../Cenon/messages.h"
#include "../Cenon/functions.h"
#include "AstroPanel.h"
#include "APMandala.h"
#include "APChart.h"
#include "../AstroMandala.h"
#include "../astroLocations.h"
#include "../EventManager.h"
#include "../AstroPrincipal.h"

@interface APMandala(PrivateMethods)
@end

@implementation APMandala

- init
{
    [self setDelegate:self];
    return [super init];
}

- (NSMutableDictionary*)features
{   NSMutableDictionary	*dict = [NSMutableDictionary dictionary];
    int			mapping = MAP_CIRCULAR;

    [dict setObject:[dividerFromField stringValue] forKey:@"dividersFrom"];
    [dict setObject:[dividerToField stringValue] forKey:@"dividersTo"];

    if ([[dimensionSwitches cellAtRow:DIM_X column:0] state])
        [dict setObject:@"1" forKey:@"dimensionX"];
    if ([[dimensionSwitches cellAtRow:DIM_Y column:0] state])
        [dict setObject:@"1" forKey:@"dimensionY"];

    if ([mappingPopup indexOfSelectedItem] == MAP_CARTESIAN)
        mapping = MAP_CARTESIAN;
    [dict setObject:[NSNumber numberWithInt:mapping] forKey:@"mapping"];

    return dict;
}

/* start calculation of chart
 */
- (void)set:(id)sender
{   NSCalendarDate	*utc;
    float		lat, lon;
    Document		*doc = [(App*)NSApp currentDocument];
    DocView		*view = [doc documentView];
    APChart		*apChart = [[Astro_Principal astroPanel] windowAt:AP_CHART];

    lat = [apChart latitude];
    lon = [apChart longitude];
    utc = [apChart date];

    if (!astroMandala && view && [[doc name] hasPrefix:MANDALA_PREFIX] )
        astroMandala = [[AstroMandala mandalaWithView:view] retain];
    else if (astroMandala && view && [[doc name] hasPrefix:MANDALA_PREFIX] )
        [astroMandala setView:view];

    [astroMandala setFeatures:[self features]];
    [astroMandala mandala:utc longitude:lon latitude:lat city:[apChart city] title:[apChart title]];
}

- (id)astroMandala
{
    return astroMandala;
}

/*
 * mandala methods
 */



/*
 * notifications
 */



/* created:  1993-07-22
 * modified: 2003-06-22
 */
- (void)dealloc
{
    [super dealloc];
}

@end
