/*
 * AstroPanel.m
 *
 * Copyright 1999-2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  1995-08-10
 * Modified: 2004-06-04
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include <VHFShared/vhfCommonFunctions.h>
#include <VHFShared/VHFSystemAdditions.h>
#include "AstroPanel.h"
#include "../astroMessages.h"
#include "APBasicLevel.h"

@implementation AstroPanel

#if USE_TABVIEW	// GNUstep, MAC-OS X
- (BOOL)canBecomeKeyWindow	{ return YES; }

- init
{   NSTabViewItem	*item;

    [super init];

    [tabView setDelegate:self];

    item = [[NSTabViewItem alloc] initWithIdentifier:@"Chart"];
    [item setLabel:@"Chart"];
    [item setView:[[self windowAt:AP_CHART] contentView]];
    [tabView addTabViewItem:item];
    activeWindow = chartWindow;

    item = [[NSTabViewItem alloc] initWithIdentifier:@"Map"];
    [item setLabel:TABMAP_STRING];
    [item setView:[[self windowAt:AP_MAP] contentView]];
    [tabView addTabViewItem:item];

    item = [[NSTabViewItem alloc] initWithIdentifier:@"Search"];
    [item setLabel:TABSEARCH_STRING];
    [item setView:[[self windowAt:AP_SEARCH] contentView]];
    [tabView addTabViewItem:item];

    /*item = [[NSTabViewItem alloc] initWithIdentifier:@"Mandala"];
    [item setLabel:@"Mandala"];
    [item setView:[[self windowAt:AP_MANDALA] contentView]];
    [tabView addTabViewItem:item];*/

    return self;
}

/* delegate: update view of tabViewItem
 */
- (void)tabView:(NSTabView*)tabView willSelectTabViewItem:(NSTabViewItem*)tabViewItem
{
    /* click on tab -> set parent view
     */
    if ( !setSubLevel )
    {
        if ( [[tabViewItem identifier] isEqual:@"Chart"] && activeWindow != chartWindow )
        {
            [activeWindow displayWillEnd];
            [tabViewItem setView:[[self windowAt:AP_CHART] contentView]];
            activeWindow = chartWindow;
        }
        else if ( [[tabViewItem identifier] isEqual:@"Map"] && activeWindow != mapWindow )
        {
            [activeWindow displayWillEnd];
            [tabViewItem setView:[[self windowAt:AP_MAP] contentView]];
            activeWindow = mapWindow;
        }
        else if ( [[tabViewItem identifier] isEqual:@"Search"] && activeWindow != searchWindow )
        {
            [activeWindow displayWillEnd];
            [tabViewItem setView:[[self windowAt:AP_SEARCH] contentView]];
            activeWindow = searchWindow;
        }
        else if ( [[tabViewItem identifier] isEqual:@"Mandala"] && activeWindow != mandalaWindow )
        {
            [activeWindow displayWillEnd];
            [tabViewItem setView:[[self windowAt:AP_MANDALA] contentView]];
            activeWindow = mandalaWindow;
        }
        [activeWindow update:self];
    }
}

/* set view of tabView (sub tabs)
 */
- (void)setLevelAt:(int)level
{   NSTabViewItem	*item;
    NSView		*newView = [[self windowAt:level] contentView];

    [activeWindow displayWillEnd];
    setSubLevel = YES;
    switch ( level )
    {
     	case AP_CHART:
     	case AP_MAP:
     	case AP_SEARCH:
     	case AP_MANDALA:
            item = [tabView tabViewItemAtIndex:level];
            if ( [item view] != newView )
            {   [[item view] retain];
#ifdef GNUSTEP_BASE_VERSION
                [tabView selectTabViewItem:nil];	// GNUstep: old views are not removed
#endif
                [item setView:newView];
                [tabView selectTabViewItemAtIndex:level];
	    }
    }
    setSubLevel = NO;
    activeWindow = [self windowAt:level];
    [activeWindow update:self];
}

#else	// OpenStep

- init
{
    [self clickLevel:self];
    return self;
}

- (void)clickLevel:sender
{
   return [self setLevelAt:[levelRadio selectedColumn]];
}

/* attention to the -init if it is not subclassed you will loss the window!
 */
- (void)setLevelAt:(int)level
{
    [activeWindow displayWillEnd];
    if (level < 10)
        [levelRadio selectCellAtRow:0 column:level];
    switch ( level )
    {
        case AP_CHART:		// astro chart
            [self windowAt:AP_CHART];
            [self setLevelView:[chartWindow contentView]];
            activeWindow = chartWindow;
            break;
        case AP_MAP:		// map
            [self windowAt:AP_MAP];
            [self setLevelView:[mapWindow contentView]];
            activeWindow = mapWindow;
            break;
        case AP_SEARCH:		// search
            [self windowAt:AP_SEARCH];
            [self setLevelView:[searchWindow contentView]];
            activeWindow = searchWindow;
            break;
        case AP_MANDALA:	// mandala
            [self windowAt:AP_MANDALA];
            [self setLevelView:[mandalaWindow contentView]];
            activeWindow = mandalaWindow;
            break;
        default:
            [self setLevelView:NULL];
            activeWindow = self;
            return;
    }

    [activeWindow update:self];
    [self orderFront:self];
}

- (void)setLevelView:theView
{
    [levView setContentView:[theView retain]];
    [theView setAutoresizingMask:NSViewWidthSizable|NSViewHeightSizable];

    [self display];
    [self flushWindow]; 
}

#endif	// end OpenStep

- (void)update:sender
{
    [chartWindow update:sender];
    [mapWindow update:sender];
    [searchWindow update:sender];
    [mandalaWindow update:sender];
}

- (id)activeWindow
{
    return activeWindow;
}

- windowAt:(int)level
{
    switch (level)
    {
        case AP_CHART:
            if ( !chartWindow )
            {	if (![NSBundle loadModelNamed:@"APChart" owner:self])
                    NSLog(@"Cannot load APChart model");
                [[chartWindow init] setWindow:self];
                [[chartWindow contentView] retain];	// GNUstep
            }
            return chartWindow;
        case AP_MAP:
            if ( !mapWindow )
            {	if (![NSBundle loadModelNamed:@"APMap" owner:self])
                    NSLog(@"Cannot load APMap model");
                [[mapWindow init] setWindow:self];
                [[mapWindow contentView] retain];	// GNUstep
            }
            return mapWindow;
        case AP_SEARCH:
            if ( !searchWindow )
            {	if (![NSBundle loadModelNamed:@"APSearch" owner:self])
                    NSLog(@"Cannot load APSearch model");
                [[searchWindow init] setWindow:self];
                [[searchWindow contentView] retain];	// GNUstep
            }
            return searchWindow;
        case AP_MANDALA:
            if ( !mandalaWindow )
            {	if (![NSBundle loadModelNamed:@"APMandala" owner:self])
                    NSLog(@"Cannot load APMandala model");
                [[mandalaWindow init] setWindow:self];
                [[mandalaWindow contentView] retain];	// GNUstep
            }
            return mandalaWindow;
        default: return nil;
    }
}

/*
 * we overwrite this to catch a keyDown before NSMatrix etc. does
 */
- (void)sendEvent:(NSEvent *)event
{
    if ( event && [event type] == NSKeyDown )
    {
        /* we remove the modifiers when we pass down the event,
         * so we can use control for the speed control of DPControl
         */
        event = [NSEvent keyEventWithType:[event type] location:[event locationInWindow] modifierFlags:0
                                timestamp:[event timestamp] windowNumber:[event windowNumber]
                                  context:[event context] characters:[event charactersIgnoringModifiers]
              charactersIgnoringModifiers:[event charactersIgnoringModifiers] isARepeat:[event isARepeat]
                                  keyCode:[event keyCode]];
        if ( [[event characters] isEqual:@"\t"] )
            tabEvent = YES;
    }
    [super sendEvent:event];
}

/* send for NSMatrix and NSTextField
 */
- (void)controlTextDidEndEditing:(NSNotification *)aNotification
{   id	matrix = [aNotification object];

    if ( tabEvent )
    {
        if ( [[matrix selectedCell] action] )
            [[[matrix selectedCell] target] performSelector:[[matrix selectedCell] action]
                                                 withObject:[matrix selectedCell]];
        else if ( [matrix action] )
            [[matrix target] performSelector:[matrix action] withObject:matrix];
        tabEvent = NO;
    }
}

@end
