/* DocViewAstro.h
 * Astrology Additions for DocView
 *
 * Copyright (C) 1998-2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1998-12-19
 * modified: 2004-03-10
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_DOCVIEWASTRO
#define VHF_H_DOCVIEWASTRO

#include "../Cenon/DocView.h"

@interface DocView(Astro)
- (NSCalendarDate*)sideralTime:(NSCalendarDate*)gmt longitude:(float)l;
- (float)mc:(NSCalendarDate*)sideralTime;
- (float)ac:(NSCalendarDate*)sideralTime latitude:(float)lat;
//- (NSCalendarDate*)dateForPlanet:(NSString*)planet at:(NSCalendarDate*)gmt plusOffset:(float)offset;

- (void)setCrossAt:(NSPoint)p layer:(int)layer;
- (VText*)text:(NSString*)string origin:(NSPoint)p color:(NSColor*)color angle:(float)angle
        center:(NSPoint)cp lineHeight:(float)lineHeight
         align:(NSTextAlignment)mode font:(NSFont*)font;
- (VText*)text:(NSString*)string base:(NSPoint)p color:(NSColor*)color angle:(float)angle
        center:(NSPoint)cp font:(NSFont*)font;
- (VText*)text:(NSString*)string base:(NSPoint)p color:(NSColor*)color angle:(float)angle
        center:(NSPoint)cp lineHeight:(float)lineHeight font:(NSFont*)font;
- (VText*)text:(NSString*)string base:(NSPoint)p color:(NSColor*)color angle:(float)angle
        center:(NSPoint)cp align:(NSTextAlignment)mode font:(NSFont*)font;
- (VText*)text:(NSString*)string base:(NSPoint)p color:(NSColor*)color angle:(float)angle
        center:(NSPoint)cp lineHeight:(float)lineHeight
         align:(NSTextAlignment)mode font:(NSFont*)font;
- (VText*)text:(NSString*)string center:(NSPoint)p color:(NSColor*)color angle:(float)angle
        center:(NSPoint)cp font:(NSFont*)font;
- (VText*)text:(NSString*)string center:(NSPoint)p color:(NSColor*)color angle:(float)angle
        center:(NSPoint)cp lineHeight:(float)lineHeight font:(NSFont*)font;
@end

#endif // VHF_H_DOCVIEWASTRO
