/* Waves.h
 * This calculates waves for the Astro chart
 *
 * Copyright (C) 2005 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2005-07-27
 * modified: 2005-07-27
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_WAVES
#define VHF_H_WAVES

#include <AppKit/AppKit.h>

@interface Waves:NSObject
{
    NSArray	*colors;
}

+ (id)sharedInstance;

- (NSArray*)wavesForDegreesInArray:(NSArray*)degArray;
- (VGroup*)wavesForObjects:(double*)objs   cnt:(int)objCnt
                     nodes:(double*)nodes  cnt:(int)nodeCnt
                    houses:(double*)houses cnt:(int)houseCnt
                    center:(NSPoint)center radius:(float)radius amplitude:(float)amp;

@end

#endif // VHF_H_WAVES
