/* astroCommon.h
 * Common astronomical functions
 *
 * Copyright (C) 1998-2006 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1998-11-06
 * modified: 2006-02-02
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTROCOMMON
#define VHF_H_ASTROCOMMON

float sunNode(int year);

NSMutableData* reducedTable(NSData *tableData, int tableSize, double factor);
NSMutableData* normalizedTable(NSData *table, int tableSize, BOOL positive);

double *harmonicTable(int tableSize);
double *harmonicPattern(int tableSize, int depth);
double harmonicValue(double deg);

//double iterationLimit( int div, int depth );
//double degIterated( double deg, int div, int depth );

//float comparableAngle180( float a, float ref);
//float angleFromFirstToSecond( float deg1, float deg2 );
//float angleBetween( float deg1, float deg2 );

/* degree/string conversion */
NSString *stringFromDeg(float deg);
float degFromString(NSString *degString);

int sortAsNumbers(id str1, id str2, void *context);

float frac(float x);

/* modified julian day (reference = 1851) */
double vhfMJD(NSCalendarDate *date);
double vhfSideralTimeMJD(double mjd, float lon);

/* Julian Day (reference = -4712, compatible to swiss ephemeris) */
double vhfJulianDay(NSCalendarDate *date);
double vhfSideralTime(double jd, float lon);	// sideral time in hours

/* calculate astronomical values with sideral time [hours] (or better seconds and integer ???) */
double vhfRA(double sideralTime);
double vhfMC(double sideralTime);
double vhfAC(double sideralTime, float lat);
BOOL vhfIsAC(float lat, float acDeg, double st);
double vhfSideralTimeForMC(float mcDeg, NSCalendarDate *utc);
float vhfLonForSideralTime(double st, NSCalendarDate *gmt);
float vhfLonForMC(float mcDeg, NSCalendarDate *utc);
float vhfLatForAC(float acDeg, double st);

/* calculate astronomical values using NSCalendarDate (DEPRECATED !) */
NSCalendarDate *sideralTime(NSCalendarDate *gmt, float longitude);
float mc(NSCalendarDate *sideralTime);
float ac(NSCalendarDate *sideralTime, float latitude);
//float ra(NSCalendarDate *sideralTime);
//NSCalendarDate *sideralTimeWithMC(float mcDeg, NSCalendarDate *utc);
//BOOL isAC(float lat, float acDeg, NSCalendarDate *sideralTime);
//float longitudeForMC(float mcDeg, NSCalendarDate *sideralTime);
//float latitudeForAC (float acDeg, NSCalendarDate *sideralTime);

/* object symbols  */
NSString *planetSymbol(NSString *object);
NSString *nodeSymbol(NSString *planet);
NSString *zodiacSign(int sign);
NSString *aspectSymbol(float deg, float orb);

/* modulus */
double mod360(double deg);			// modulus 360 degree

/* aspects */
double standardAngle( double angle );		// modulus 360 degree
double angle(double deg1, double deg2);		// angle = [0, 360]
double angle180( double deg1, double deg2 );	// angle = [0, 180]
double mirror(double deg1, double deg2);
double midpoint(double deg1, double deg2);
double harmony(double obj, double obj1, double obj2);

/* checks */
BOOL vhfIsDegreeInsideRange(double deg, double degFr, double degTo, BOOL retro);


#endif // VHF_H_ASTROCOMMON
