/* AstroController.h
 *
 * Copyright (C) 1999-2006 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  2003-03-23
 * Modified: 2006-06-02
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_PREFASTROCONTROLLER
#define VHF_H_PREFASTROCONTROLLER

#include <AppKit/AppKit.h>
#include "../../Cenon/PreferencesPanel.subproj/PreferencesMethods.h"

#define Prefs_ShowAstroPanel	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowPanel"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_Colorful		( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroColorful"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_DegreesMinutes	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroDegreesMinutes"] isEqual:@"YES"]) ? YES : NO )

#define Prefs_Topocentric	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroTopocentricPosition"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_MeanNodes		( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroMeanNodes"] isEqual:@"YES"]) ? YES : NO )

#define Prefs_ShowRetrograde	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowRetrograde"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowHousePosition	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowHousePosition"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowHouseSize	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowHouseSize"] isEqual:@"YES"]) ? YES : NO )
/*#define Prefs_ShowHouseMaxima	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowHouseMaxima"] isEqual:@"YES"]) ? YES : NO )*/
#define Prefs_LocalScale	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroLocalScale"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_HouseDegrees	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroHouseDegrees"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowDeclination	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowDeclination"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ShowAspectGeo	( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroShowAspectGeo"] isEqual:@"YES"]) ? YES : NO )
#define Prefs_ACFix		( ([[[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroACFix"] isEqual:@"YES"]) ? YES : NO )

#define Prefs_BGColor		vhfRGBColorFromString([[NSUserDefaults standardUserDefaults] \
                                     objectForKey:@"astroBGColor"])
#define Prefs_DateFormat	[[NSUserDefaults standardUserDefaults] objectForKey:@"astroDateFormat"]
#define Prefs_AstroFont		[[NSUserDefaults standardUserDefaults] objectForKey:@"astroFont"]
#define Prefs_Objects		[[NSUserDefaults standardUserDefaults] objectForKey:@"astroObjects"]
#define Prefs_Nodes		[[NSUserDefaults standardUserDefaults] objectForKey:@"astroNodes"]
#define Prefs_AstroInterval	[[[NSUserDefaults standardUserDefaults] objectForKey:@"astroInterval"] intValue]

/* switches in generalSwitches */
typedef enum
{
    SWITCH_SHOWASTROPANEL  =  0,
    SWITCH_COLORFUL        =  1,	// use colors for house tips etc.
    SWITCH_DEGREESMINUTES  =  2
}AstroGeneralSwitches;

/* switches in objectSwitches */
typedef enum
{
    SWITCH_TOPOCENTRIC	   =  0,	// topocentric planet positions (at location on earth)
    SWITCH_MEANNODES       =  1		// mean nodes instead of true nodes
}AstroObjectsSwitches;

/* switches in chartSwitches */
typedef enum
{
    SWITCH_SHOWRETROGRADE  =  0,
    SWITCH_SHOWHOUSEPOS    =  1,	// house degrees
    SWITCH_SHOWHOUSESIZE   =  2,	// display size of house
    //SWITCH_SHOWHOUSEMAXIMA =  2,	// mark maxima of house
    SWITCH_LOCALSCALE      =  3,	// topocentric degree scale
    SWITCH_HOUSEDEGREES	   =  4,	// planet positions relative houses
    SWITCH_SHOWDECLINATION =  5,
    SWITCH_SHOWASPECTGEO   =  6,	// aspect lines
    SWITCH_ACFIX           =  7		// AC rotated to the left
}AstroChartSwitches;

/* Objects */
#define OBJECTS_1		[NSArray arrayWithObjects: \
                                  @"Sun", @"Moon", @"Mercury", @"Venus", @"Mars", \
                                  @"Jupiter", @"Saturn", @"Uranus", @"Neptune", @"Pluto", nil]
#define OBJECTS_2		[NSArray arrayWithObjects: \
                                  @"Node", @"True Node", @"Apogee", @"True Apogee", \
                                  @"Chiron", @"Pholus", @"Ceres", @"Pallas", @"Juno", @"Vesta", nil]

/* notifications */
#define AstroPrefsCallToAddItemsNotification	@"AstroPrefsCallToAddItems"	// modules should add their panes
#define AstroPrefsAddItemNotification		@"AstroPrefsAddItem"		// we have to add a new menu item

@interface AstroController:NSObject <PreferencesMethods>
{
    /* Preferences Pane */
    id box;		// the Astro Preferences box
    id subBox;		// the box for sub-modules
    id menuMatrix;	// the menu items

    /* General */
    id boxGeneral;
    id generalSwitches;	// the switches
    id datePopup;	// the date format popup
    id fontPopup;	// the font popup

    /* Objects */
    id boxObjects;
    id objectSwitches;	// switch options for objects
    id object1Switches;	// planets
    id nodeSwitches;	// planet nodes
    id object2Switches;	// moon nodes and asteroids

    /* Chart */
    id boxChart;	// the view with the chart preferences
    id bgColorWell;	// color well for background color
    id chartSwitches;	// the chart switches
    id chartIntervalField;	// time interval

    /* Map */
    //id boxMap;	// the view with the map preferences

    NSMutableArray	*prefViews;	// preferences modules (boxGeneral, boxObjects, boxChart, ...)
}

- (void)set:sender;
- (void)setGeneral:sender;
- (void)setObjects:sender;
- (void)setChart:sender;
//- (void)setMap:sender;

- (void)setLevel:sender;

@end

#endif // VHF_H_PREFASTROCONTROLLER
