/* AstroPrincipal.h
 * Cenon Application additions for Astrology module
 *
 * Copyright (C) 2003-2006 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2003-03-28 (extracted from App.h)
 * modified: 2006-05-13
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTROPRINCIPAL
#define VHF_H_ASTROPRINCIPAL

#include "../Cenon/CenonModuleMethods.h"
#include "SwissEphemeris.subproj/Ephemeris.h"
#include "AstroPanels.h"
#include "EventManager.h"
#include "CityManager.h"
#include "TimeZoneManager.h"

/* get principal */
#define Astro_Principal [[[NSBundle bundleForClass:[AstroPrincipal class]] principalClass] instance]

/* notifications */
#define CalculateChartNotification	@"AstroCalculateChart"	// we have to calculate a chart with the given data
#define AstroDateSetNotification	@"AstroDateSet"		// whatever we want to do with the date...
#define AstroAddChartParts		@"AstroAddChartParts"	// give modules etc. a chance to draw stuff

@interface AstroPrincipal:NSObject <CenonModuleMethods>
{
    AstroPanel		*astroPanel;		// the astro panel
    EventManager	*eventManager;		// the event manager
    CityManager		*cityManager;		// the city manager
    TimeZoneManager	*timeZoneManager;	// the time zone manager
    Ephemeris		*ephemeris;		// the shared ephemeris object
}

+ (id)instance;
+ (NSString*)stringFromDeg:(float)deg;

- (void)showAstroPanel:sender;
- (id)astroPanel;

- (id)eventManager;
- (id)cityManager;
- (id)timeZoneManager;

- (Ephemeris*)ephemeris;

@end

#endif // VHF_H_ASTROPRINCIPAL
