/* AstroPanel.h
 *
 * Copyright (C) 1999-2008 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  1995-08-10
 * Modified: 2008-03-17
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTROPANEL
#define VHF_H_ASTROPANEL

#include "APBasicLevel.h"

#define AP_CHART        0
#define AP_MAP          1
#define AP_SEARCH       2
#define AP_FLOWCHART    3
#define AP_DEFAULT      99

#define BUTTONLEFT      0
#define BUTTONRIGHT     1
#define BUTTONUP        2
#define BUTTONDOWN      3

#if !defined(GNUSTEP_BASE_VERSION) && !defined(__APPLE__)
    #define USE_TABVIEW 0
#else
    #define USE_TABVIEW 1
#endif

/* notifications */
#define AstroPanelAddTabNotification	@"AstroPanelAddTab"	// we have to add a new tab

@interface AstroPanel:APBasicLevel
{
    id              levelRadio;
#if USE_TABVIEW
    NSTabView       *tabView;
    BOOL            setSubLevel;
#else
    NSScrollView    *levView;
#endif

    int			levelCnt;
    id			windows[10];
    id			chartWindow;
    id			mapWindow;
    id			searchWindow;
    id			flowWindow;

    id			activeWindow;
    BOOL		tabEvent;
}

- awakeFromNib;
- (void)update:sender;
- (void)setLevelAt:(int)level;

#if !USE_TABVIEW
    - (void)clickLevel:sender;
    - (void)setLevelView:theView;
#endif

- (id)activeWindow;
- windowAt:(int)level;

@end

#endif	// VHF_H_ASTROPANEL
