/* AstroDate.m
 *
 * Copyright (C) 2006-2011 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2006-01-15
 * modified: 2011-07-11 (dateSeps)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTRODATE
#define VHF_H_ASTRODATE

@interface AstroDate:NSObject
{
    NSArray		*dateFormats;
    NSArray		*dateMasks, *dateSeps;
    NSArray		*dateErrors;
    NSDictionary	*monDict;
}

NSString *astroErrorDate(void);
NSString *astroDateFormatForString(NSString *dateString);


+ (id)sharedInstance;

/* arrays */
- (NSArray*)dateFormats;
- (NSArray*)dateMasks;
- (NSArray*)dateErrors;

/* date methods */
- (NSString*)dateFormat;
- (int)indexOfDateFormatForString:(NSString*)dateString;
- (NSString*)dateFormatForString:(NSString*)dateString;
- (NSString*)errorString;
- (BOOL)getYear:(int*)y month:(int*)m day:(int*)d fromDateString:(NSString*)dateString;

@end

#endif // VHF_H_ASTRODATE
