/* EphemerisSearch.h
 * search Ephemeris data
 *
 * Copyright (C) 2004-2006 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2004-04-12
 * modified: 2006-01-27
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_EPHEMERISSEARCH
#define VHF_H_EPHEMERISSEARCH

#include	"../Astro/SwissEphemeris.subproj/Ephemeris.h"

/* aspect type */
typedef enum
{
    /* single aspects (object1) */
    S_ASPECT_LON		= 0,	// ecliptic longitude of objects
    S_ASPECT_DEC		= 1,	// declination of objects
    S_ASPECT_LOCAL		= 2,	// local topocentric position of objects

    /* pair aspects (object1 + object2) */
    S_ASPECT_ANGLE		= 3,	// angle  between objects (ecliptic lon)
    S_ASPECT_MIRROR		= 4,	// mirror between objects (ecliptic lon)
    S_ASPECT_PARALLEL		= 5,	// parallel of objects (declination mirror)
    S_ASPECT_DEC_ANGLE		= 6,	// declination angle
    S_ASPECT_LOCAL_ANGLE	= 7,	// local angle  between objects (scale of current houses)
    S_ASPECT_LOCAL_MIRROR	= 8,	// local mirror between objects (scale of current houses)
    //S_ASPECT_RADIX_ANGLE	= 9,	// angles  between objects (scale of radix houses)
    //S_ASPECT_RADIX_MIRROR	= 10,	// mirrors between objects (scale of radix houses)

    /* triple aspects */
    S_ASPECT_MIDPOINT		= 11,	// midpoint between objects (one planet as mirror)

    /* transit aspects */
    S_ASPECT_TRANS_LOCAL	= 12,	// transite
    S_ASPECT_TRANS_ANGLE	= 13,	// transit angle
    S_ASPECT_TRANS_MIRROR	= 14,	// transit mirror
    S_ASPECT_TRANS_PARALLEL	= 15	// transit parallel
} SearchAspectType;

typedef struct
{
    double	val;		// value
    double	v;		// speed
} AstroAspectValue;

@interface EphemerisSearch:NSObject
{
    Ephemeris	*ephemeris;

    /* progress indicator */
    id		progressTarget;
    SEL		progressAction;

    /* topocentric search */
    BOOL	topocentricSearch;
    float	topoLat, topoLon;	// latitude, longitude
    int		topoElev;		// elevation
}

/* init */
+ newWithEphemeris:(Ephemeris*)eph;
- (id)initWithEphemeris:(Ephemeris*)eph;
- (void)setProgressTarget:(id)target action:(SEL)action;
- (void)setTopocentricSearch:(BOOL)topoFlag lat:(float)lat lon:(float)lon elev:(int)elev;

/* basic search for single aspect */
- (NSArray*)searchFromDate:(NSCalendarDate*)dateFr toDate:(NSCalendarDate*)dateTo
                   object1:(EphemerisObjects)obj1 object2:(EphemerisObjects)obj2
                    aspect:(SearchAspectType)aspType aspectValue:(double)aspVal;

/* composite search (almighty) */
- (NSDictionary*)searchWithFeatures:(NSDictionary*)features
                           fromDate:(NSCalendarDate*)dateFrom toDate:(NSCalendarDate*)dateTo
                     searchInterval:(int)minutes;

/* search aspects */
- (NSDictionary*)searchAspect:(NSString*)planet1 :(NSString*)planet2
                     dividers:(NSArray*)dividers
                 searchAngles:(BOOL)searchAngles searchMirrors:(BOOL)searchMirrors
                     fromDate:(NSCalendarDate*)dateFrom toDate:(NSCalendarDate*)dateTo
               searchInterval:(int)minutes;

/* search transits */

@end

#endif	// VHF_H_EPHEMERISSEARCH
