/* APSearch.m
 *
 * Copyright (C) 2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  2004-05-20
 * Modified: 2004-05-24
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_APSEARCH
#define VHF_H_APSEARCH

#include <AppKit/AppKit.h>
#include "APBasicLevel.h"
#include "../EphemerisSearch.h"

/* aspect switches */
#define SHOW_ASPECTS	0
#define SHOW_MIRRORS	1

/* search type */
#define SEARCH_ASPECTS	0
#define SEARCH_TRANSITS	1

@interface APSearch:APBasicLevel
{
    id fromField;
    id toField;
    id planet1Popup;
    id planet2Popup;
    id dividerField;	// the divider aspects to search for
    id aspectSwitches;	// which kind of aspects
    id searchTypePopup;	// search for aspects or transits ?
    id textView;	// the list of aspects

    EphemerisSearch	*ephemerisSearch;
    NSMutableArray	*planetList;
    NSMutableDictionary	*aspectList;
    NSArray		*aspectKeys;
}

- (void)set:sender;
- (void)add:sender;

@end

#endif	// VHF_H_APSEARCH
