/* astroMessages.h
 * common bundle messages
 *
 * Copyright (C) 2003-2010 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2003-06-22
 * modified: 2006-05-10
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTROMESSAGES
#define VHF_H_ASTROMESSAGES

#define ASTRO_BUNDLE                [NSBundle bundleForClass:[AstroPrincipal class]]
#define VHFLocalAstroString(key)    NSLocalizedStringFromTableInBundle(key, @"Astro", ASTRO_BUNDLE, NULL)

/* Preferences */
#define PREF_GENERAL_TITLE		VHFLocalAstroString(@"General")

/* General */
#define DEGREE_FORMAT			VHFLocalAstroString(@"%@ %@'%@\"")
#define REALLYMODIFY_STRING		VHFLocalAstroString(@"Do you really want to modify '%@' ?")

/* Astro Panel: Tabs */
#define TABCHART_STRING			VHFLocalAstroString(@"Chart")
#define TABMAP_STRING			VHFLocalAstroString(@"Map")
#define TABSEARCH_STRING		VHFLocalAstroString(@"Search")
#define TABFLOWCHART_STRING		VHFLocalAstroString(@"Flow Chart")

/* Flow Chart */

/* Event Manager */
#define REALLYDELETEFOLDER_STRING	VHFLocalAstroString(@"Do you really want to remove the folder '%@' ?")
#define REALLYDELETEEVENT_STRING	VHFLocalAstroString(@"Do you really want to remove the event '%@' ?")
#define WRONGDATEFORMAT_STRING		VHFLocalAstroString(@"Please specify the date in the format '%@'")

/* City Manager */
#define REALLYDELETECITY_STRING		VHFLocalAstroString(@"Do you really want to remove the city '%@' ?")

#endif // VHF_H_ASTROMESSAGES
