/* APMap.h
 *
 * Copyright (C) 2001-2006 by vhf interservice GmbH
 * Author: Georg Fleischmann
 *
 * Created:  2001-05-18
 * Modified: 2006-02-20
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_APMAP
#define VHF_H_APMAP

#include <AppKit/AppKit.h>
#include "APBasicLevel.h"

typedef enum
{
    SWITCH_SHOWACMC    = 0,	// show AC, MC lines to objects
    SWITCH_SHOWHOUSES  = 1,	// show house tips
    SWITCH_SHOWZODIAC  = 2,
    SWITCH_SHOWDEGREES = 3,
    SWITCH_SHOWTRACKS  = 4	// show time tracks of objects
}MapShowSwitches;

typedef enum
{
    SWITCH_CLICKCHART  = 0,	// update Astro Chart
    SWITCH_CLICKINFO   = 1	// show info for location and time
}MapClickSwitches;

@interface APMap:APBasicLevel
{
    id	regionPopup;
    id	gridPopup;
    id	degreePopup;
    id	objectPopup;
    id	clickSwitches;
    id	showSwitches;
    id	earthSwitch;	// wheather to show earth revolution or skip days
    id	dateFrField;	// for time tracks
    id	dateToField;	// for time tracks

    NSArray		*objectList;	// list of item names in object popups
    NSMutableDictionary	*mapDict;
}

- (void)set:sender;
//- (void)valuesToRadixAC:(float)radixAC atLat:(float)lat lon:(float)lng;

@end

#endif	// VHF_H_APMAP
