/* DocViewMap.h
 * Map Additions for DocView
 *
 * Copyright (C) 1998-2006 by Cenon GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1998-12-19
 * modified: 2006-02-19
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#ifndef CEN_H_DOCVIEWMAP
#define CEN_H_DOCVIEWMAP

#include "../Cenon/DocView.h"
#include "CIAMaps.subproj/CIAMap.h"

#define MAP_PREFIX	@"Map"	// the prefix of the filename of maps

@interface DocView(Map)

- (void)initMap;
- (BOOL)isMap;

- (void)setMapRadix:(NSEvent*)event;
//- (void)setCIAMap:(CIAMap*)amap;
- (CIAMap*)ciaMap;
- (void)createMapWithCenter:(NSPoint)center size:(NSSize)size grid:(float)gridSize
                   features:(NSDictionary*)features;

@end

#endif // CEN_H_DOCVIEWMAP
