/* AstroDate.m
 *
 * Copyright (C) 2006-2011 by Georg Fleischmann
 * Author:   Georg Fleischmann
 *
 * created:  2006-01-15
 * modified: 2011-07-11 (dateSeps)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#ifndef CEN_H_ASTRODATE
#define CEN_H_ASTRODATE

@interface AstroDate:NSObject
{
    NSArray		*dateFormats;
    NSArray		*dateMasks, *dateSeps;
    NSArray		*dateErrors;
    NSDictionary	*monDict;
}

NSString *astroErrorDate(void);
NSString *astroDateFormatForString(NSString *dateString);


+ (id)sharedInstance;

/* arrays */
- (NSArray*)dateFormats;
- (NSArray*)dateMasks;
- (NSArray*)dateErrors;

/* date methods */
- (NSString*)dateFormat;
- (int)indexOfDateFormatForString:(NSString*)dateString;
- (NSString*)dateFormatForString:(NSString*)dateString;
- (NSString*)errorString;
- (BOOL)getYear:(int*)y month:(int*)m day:(int*)d fromDateString:(NSString*)dateString;

@end

#endif // CEN_H_ASTRODATE
