/* CityManager.h
 *
 * Copyright (C) 2003-2004 by Georg Fleischmann
 * Author:   Georg Fleischmann
 *
 * created:  2003-06-29
 * modified: 2004-10-06
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#ifndef CEN_H_CITYMANAGER
#define CEN_H_CITYMANAGER

#include <AppKit/AppKit.h>

#define AstroUpdateCity	@"AstroUpdateCity"

@interface CityManager:NSObject
{
    id	cityPanel;
    id	cityBrowser;
    id	folderField;
    id	countryField;
    id	cityField;
    id	latField;
    id	lonField;
    id	elevField;
    id	zipField;
    id	zipMaxField;

    NSMutableArray	*cityKeys;	// the sorted keys of the city dictionary
    NSMutableDictionary	*cities;	// the cities of the current state
    NSMutableArray	*folders;	// states
}

/* action methods */
- (void)showPanel:sender;

//- (void)addFolder:sender;
//- (void)renameFolder:sender;
//- (void)removeFolder:sender;

- (void)add:sender;
- (void)modify:sender;
- (void)remove:sender;
- (void)clear:sender;
- (void)search:sender;
- (void)set:sender;

@end

#endif	// CEN_H_CITYMANAGER
