/* astroCommon.h
 * Common astronomical functions
 *
 * Copyright (C) 1998-2015 by Cenon GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1998-11-06
 * modified: 2015-12-19 (cenNSDateFromJD() added)
 *           2015-05-14 (cenJD() added)
 *           2014-12-13 (asc. invariable node)
 *           2011-03-21 (vhfJDFromNSDate)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#ifndef CEN_H_ASTROCOMMON
#define CEN_H_ASTROCOMMON

#include <VHFShared/vhfCompatibility.h>     // CGFloat for OS X 10.4

double sunNode(int year);           // sun equator + ecliptic
double invariableNode(int year);    // ascending invariable node

NSMutableData* reducedTable(NSData *tableData, int tableSize, double factor);
NSMutableData* normalizedTable(NSData *table, int tableSize, BOOL positive);

double *harmonicTable(int tableSize);
double *harmonicPattern(int tableSize, int depth);
double harmonicValue(double deg);

//double iterationLimit( int div, int depth );
//double degIterated( double deg, int div, int depth );

//float comparableAngle180( float a, float ref);
//float angleFromFirstToSecond( float deg1, float deg2 );
//float angleBetween( float deg1, float deg2 );

/* degree/string conversion */
NSString *stringFromDeg(float deg);
float degFromString(NSString *degString);

NSInteger sortAsNumbers(id str1, id str2, void *context);

float frac(float x);

/* modified julian day (reference = 1851) */
double vhfMJD(NSCalendarDate *date);
double vhfSideralTimeMJD(double mjd, float lon);

/* Julian Day (reference = -4712, compatible to swiss ephemeris) */
double cenJD(int year, int month, int day, int H, int M, int S);
double cenJDFromNSDate(NSDate *date);
/* DEPRECATED */ double vhfJDFromNSDate(NSDate *date);
double vhfJulianDay(NSCalendarDate *date);
double vhfJulianDayFromInt(int yyyymmdd, int hhmm);
//double vhfJulianDayFromNSDate(NSCalendarDate *date);
int cenIntDateFromJD(double jd, int *yymmdd, int *hhmm);
int cenIntDateFromJulianDay(double jd, int *yymmdd, int *hhmm);
/* DEPRECATED */ int vhfIntDateFromJulianDay(double jd, int *yymmdd, int *hhmm);
NSDate *cenNSDateFromJD(double jd);
//NSDate *cenNSDateFromJulianDay(double jd);
/* DEPRECATED */ NSCalendarDate *vhfNSDateFromJD(double jd);
double vhfSideralTime(double jd, float lon);	// sideral time in hours

/* calculate astronomical values with sideral time [hours] (or better seconds and integer ???) */
double vhfRA(double sideralTime);
double vhfMC(double sideralTime);
double vhfAC(double sideralTime, float lat);
BOOL vhfIsAC(float lat, float acDeg, double st);
double vhfSideralTimeForMC(float mcDeg, NSCalendarDate *utc);
float vhfLonForSideralTime(double st, NSCalendarDate *gmt);
float vhfLonForMC(float mcDeg, NSCalendarDate *utc);
float vhfLatForAC(float acDeg, double st);

/* calculate astronomical values using NSCalendarDate (DEPRECATED ! too slow and no BC) */
NSCalendarDate *sideralTime(NSCalendarDate *gmt, float longitude);
float mc(NSCalendarDate *sideralTime);
float ac(NSCalendarDate *sideralTime, float latitude);
//float ra(NSCalendarDate *sideralTime);
//NSCalendarDate *sideralTimeWithMC(float mcDeg, NSCalendarDate *utc);
//BOOL isAC(float lat, float acDeg, NSCalendarDate *sideralTime);
//float longitudeForMC(float mcDeg, NSCalendarDate *sideralTime);
//float latitudeForAC (float acDeg, NSCalendarDate *sideralTime);

/* object symbols  */
NSString *planetSymbol(NSString *object);
NSString *nodeSymbol(NSString *planet);
NSString *zodiacSign(int sign);
NSString *aspectSymbol(float deg, float orb);

/* modulo */
//double modulo(double num, double denom);    // dodulo
double mod360(double deg);                  // modulo 360 degree

/* aspects */
double standardAngle( double angle );		// modulus 360 degree
double angle(double deg1, double deg2);		// angle = [0, 360]
double angle180( double deg1, double deg2 );	// angle = [0, 180]
double mirror(double deg1, double deg2);
double midpoint(double deg1, double deg2);
double harmony(double obj, double obj1, double obj2);

/* checks */
BOOL vhfIsDegreeInsideRange(double deg, double degFr, double degTo, BOOL retro);


#endif // CEN_H_ASTROCOMMON
