/* APSearch.m
 *
 * Copyright (C) 2004-2014 by Cenon GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  2004-05-20
 * Modified: 2014-01-04 (clean up)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@cenon.de
 * http://www.cenon.info
 */

#ifndef CEN_H_APSEARCH
#define CEN_H_APSEARCH

#include <AppKit/AppKit.h>
#include "APBasicLevel.h"
#include "../EphemerisSearch.h"

/* aspect switches */
#define SHOW_ASPECTS	0
#define SHOW_MIRRORS	1

/* search type */
#define SEARCH_ASPECTS	0
#define SEARCH_TRANSITS	1

@interface APSearch:APBasicLevel // <NSWindowDelegate>
{
    id fromField;
    id toField;
    id planet1Popup;
    id planet2Popup;
    id dividerField;	// the divider aspects to search for
    id aspectSwitches;	// which kind of aspects
    id searchTypePopup;	// search for aspects or transits ?
    id textView;	// the list of aspects

    EphemerisSearch     *ephemerisSearch;
    NSArray             *planetList;
    NSMutableDictionary	*aspectList;
    NSArray             *aspectKeys;
}

- (void)set:sender;
- (void)add:sender;

@end

#endif	// CEN_H_APSEARCH
