/* functions.h
 * Common Cenon functions
 *
 * Copyright (C) 1996-2005 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1996-01-25
 * modified: 2005-01-04
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_FUNCTIONS
#define VHF_H_FUNCTIONS

#include <AppKit/AppKit.h>

#define UNIT_MM		0
#define UNIT_INCH	1
#define UNIT_POINT	2

NSString *localLibrary(void);
NSString *userLibrary(void);
NSString *localBundlePath(void);
NSString *systemBundlePath(void);
NSString *userBundlePath(void);

void fillPopup(id popupButton, NSString *folder, NSString *ext, int removeIx );
NSDictionary *dictionaryFromFolder(NSString *folder, NSString *name);

float convertToUnit(float value);
float convertFromUnit(float value);
float convertMMToUnit(float value);
float convertUnitToMM(float value);

NSString *vhfStringFromRGBColor(NSColor *color);
NSColor *vhfRGBColorFromString(NSString *string);

#endif	// VHF_H_FUNCTIONS
