/* AstroChart.h
 * The well known circular Astrology chart
 *
 * Copyright (C) 2001-2003 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2001-11-07
 * modified: 2003-07-25
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTROCHART
#define VHF_H_ASTROCHART

#include <AppKit/AppKit.h>
#include "DocViewAstro.h"

#define CHART_PREFIX	@"Chart"	// the prefix of the filename of charts

@interface AstroChart:NSObject
{
    DocView	*view;
    id		ephemeris;
    int		ixComposite, ixMaskComposite;	// layer indexes
    NSString	*astroFont;
}

+ (id)astroChartWithView:(DocView*)aView;
- (id)initWithView:(DocView*)aView;
- (void)setView:(id)newView;

- (void)setCompositeLayerEnabled:(BOOL)enabled;
- (void)radix:(NSCalendarDate*)gmt
    longitude:(float)longitude latitude:(float)latitude city:(NSString*)city
        title:(NSString*)title composite:(NSDictionary*)composite;
@end

#endif // VHF_H_ASTROCHART
