/* AstroMandala.h
 * Astrological Mandalas
 *
 * Copyright (C) 2003-2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2003-11-23
 * modified: 2004-06-03
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTROMANDALA
#define VHF_H_ASTROMANDALA

#include <AppKit/AppKit.h>
#include "DocViewAstro.h"

#define MANDALA_PREFIX	@"Mandala"		// the prefix of the filename of mandalas

/* mapping */
#define MAP_CIRCULAR	0
#define MAP_CARTESIAN	1

@interface AstroMandala:NSObject
{
    DocView		*view;
    id			ephemeris;

    NSArray		*planets;
    NSCalendarDate	*utc;
    float		lat, lon;
    NSDictionary	*degreeDict;

    /* parameter */
    float		planetDeg[20];		// planet representation in degrees of unit cycle
    int			mapping;		// kind of mapping (circular, cartesian)
    int			dividersFrom, dividersTo;
    int			dimensionX, dimensionY;
}

+ (id)mandalaWithView:(DocView*)aView;
- (id)initWithView:(DocView*)aView;
- (void)setView:(id)newView;

- (void)setFeatures:(NSDictionary*)features;

- (void)mandala:(NSCalendarDate*)gmt
      longitude:(float)longitude latitude:(float)latitude city:(NSString*)city
          title:(NSString*)title;
@end

#endif // VHF_H_ASTROMANDALA
