/* Map.m
 * Commander of the map
 *
 * Copyrigth (C) 2003-2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann, Ilonka Fleischmann
 *
 * created:  2003-07-14
 * modified: 2004-03-19
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_MAPFUNCTIONS
#define VHF_H_MAPFUNCTIONS

#include <Foundation/Foundation.h>
#include "DocViewMap.h"

@interface Map:NSObject
{
    NSMutableDictionary	*mapDict;	// map.plist
    NSString		*name;
    char		projectionType;	// 'M' = Mercator, 'S' = Stereographic, 'F' = Free style map
    NSPoint		origin;		// 0 lat/lon,      pole,                none
    double		scale;		// scale of the map (map unit = earth unit / scale)
    float		deg0;		// Stereo: angle of 0 meridian to horicontal axis
    NSDictionary	*freeGrid;	// Free: grid of positions
    NSRect		bounds;		// the useful bounds of the map
    NSString		*mapset;	// cia: filename of mapset
    NSPoint		center;
    NSSize		size;

    NSCalendarDate	*date;		// date of the last mapping
    NSCalendarDate	*mapDate;	// date of last loaded map
}

+ (Map*)mapWithMapDictionary:(NSDictionary*)dict;
- initWithContentsOfDictionary:(NSDictionary*)dict;

- (void)setBounds:(NSRect)rect;

/* projection */
- (NSPoint)latLonForPointOnMap:(NSPoint)mapP;
- (NSPoint)pointOnMapForLat:(float)lat lon:(float)lon;

/* mapping */
- (VGroup*)mapChartWithDate:(NSCalendarDate*)utc title:(NSString*)title inBounds:(NSRect)bounds;
- (NSCalendarDate*)date;

/* cia map */
- (BOOL)needsCalculation;
- (NSMutableDictionary*)createMap;
- (CIAMap*)ciaMap;

/* map loading */
- (void)displayMapAtDate:(NSCalendarDate*)mapDate inView:(DocView*)view;

/* archiving */
- (char)projectionType;
- (void)setFreeGrid:(NSDictionary*)grid;
- (void)writeInfoToFile:(NSString*)file;

@end

#endif // VHF_H_MAPFUNCTIONS
