#!/bin/sh
#
# OpenStep: Convert nib to gmodel files
# - temporary link images into nib files as needed
# - convert nib files to gmodel files
# - call 'Convertgmodels.sh' to correct gmodel files (class names etc.)
# - call 'Convertgmodels1.sh' to convert special characters
#
# Author:   Georg Fleischmann
# modified: 2004-10-06
#

PROJECTS=~/Projects
ASTRO=$PROJECTS/Cenon/Source/Astro
Cenon=$PROJECTS/Cenon/Source/Cenon

cd $ASTRO

for lng in English German
do

    # EventPanel, CityPanel, TimeZonePanel
    echo $lng.lproj/EventPanel.nib
    nib2gmodel $lng.lproj/EventPanel.nib $lng.lproj/EventPanel.gmodel
    nib2gmodel $lng.lproj/CityPanel.nib $lng.lproj/CityPanel.gmodel
    nib2gmodel $lng.lproj/TimeZonePanel.nib $lng.lproj/TimeZonePanel.gmodel

    # Astro.prefs
    FILE=Astro.bproj/$lng.lproj/Astro
    echo $FILE.nib
    nib2gmodel $FILE.nib $FILE.gmodel

    # AstroPanel
    for nib in AstroPanelTab APChart APMap APSearch APMandala
    do
        FILE=AstroPanel.subproj/$lng.lproj/$nib
        if [ -d $FILE.nib ]; then
          echo $FILE.nib
          ln -s $Cenon/arrow*.tiff $FILE.nib/
          nib2gmodel $FILE.nib $FILE.gmodel
          rm $FILE.nib/arrow*.tiff
        fi
    done
    if [ -f AstroPanel.subproj/$lng.lproj/AstroPanelTab.gmodel ]; then
      rm AstroPanel.subproj/$lng.lproj/AstroPanel.gmodel
      mv AstroPanel.subproj/$lng.lproj/AstroPanelTab.gmodel AstroPanel.subproj/$lng.lproj/AstroPanel.gmodel
    fi

done

# modify dictionary entries
echo
echo Correct entries from property list
echo
cd $ASTRO
$PROJECTS/Linux/GNUstep/convertgmodels/convertgmodels $ASTRO/nib2gmodel.plist

# convert special characters
echo
echo Convert special characters
echo
cd $ASTRO
../Cenon/nib2gmodel_chars.sh $ASTRO
