/* astroMessages.h
 * common bundle messages
 *
 * Copyright (C) 2003-2004 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  2003-06-22
 * modified: 2004-05-20
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_ASTROMESSAGES
#define VHF_H_ASTROMESSAGES

#define ASTRO_BUNDLE	[NSBundle bundleForClass:[AstroPrincipal class]]


#define DEGREE_FORMAT		NSLocalizedStringFromTableInBundle(@"%@ %@'%@\"", @"Astro", ASTRO_BUNDLE, NULL)


#define REALLYMODIFY_STRING	NSLocalizedStringFromTableInBundle(@"Do you really want to modify '%@' ?", \
                                @"Astro", ASTRO_BUNDLE, NULL)

/* Tabs (AstroPanel)
 */
#define TABMAP_STRING		NSLocalizedString(@"Map", NULL)
#define TABSEARCH_STRING	NSLocalizedString(@"Search", NULL)

/* Event Manager */
#define DATE1_STRING	NSLocalizedStringFromTableInBundle(@"DD.MM.YYYY HH:MM ZON", @"Astro", ASTRO_BUNDLE, NULL)
#define DATE2_STRING	NSLocalizedStringFromTableInBundle(@"YYYY-MM-DD HH:MM ZON", @"Astro", ASTRO_BUNDLE, NULL)

#define REALLYDELETEFOLDER_STRING	NSLocalizedStringFromTableInBundle(@"Do you really want to remove the folder '%@' ?", \
                                        @"Astro", ASTRO_BUNDLE, NULL)
#define REALLYDELETEEVENT_STRING	NSLocalizedStringFromTableInBundle(@"Do you really want to remove the event '%@' ?", \
                                        @"Astro", ASTRO_BUNDLE, NULL)
#define WRONGDATEFORMAT_STRING		NSLocalizedStringFromTableInBundle(@"Please specify the date in the format '%@'", \
                                        @"Astro", ASTRO_BUNDLE, NULL)

/* City Manager */
#define REALLYDELETECITY_STRING	NSLocalizedStringFromTableInBundle(@"Do you really want to remove the city '%@' ?", \
                                @"Astro", ASTRO_BUNDLE, NULL)

#endif // VHF_H_ASTROMESSAGES
