/* AstroController.m
 * Astrology Preferences controller
 *
 * Copyright (C) 1999-2005 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * Created:  2003-03-23
 * Modified: 2004-07-31
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include <AppKit/AppKit.h>
#include "AstroController.h"
#include "../../Cenon/functions.h"
#include "../../Cenon/PreferencesPanel.subproj/NotificationNames.h"

@interface AstroController(PrivateMethods)
@end

@implementation AstroController

/*
 * registration of defaults resides in [AstroPrincipal +initialize]
 */



// protocol methods

/* create new instance of GeneralController
 */
+ (id)controller
{   static AstroController *controller = nil;

    if (!controller)
        controller = [[AstroController alloc] init];
    return controller;
}

- (id)init
{
    [super init];

    if ( ![NSBundle loadNibNamed:@"Astro" owner:self] )
    {   NSLog(@"Cannot load 'Astro' interface file");
        return nil;
    }

    /* set target and action for GNUstep (not in gmodels) */
    [datePopup setTarget:self];			// set the target
    [datePopup setAction:@selector(set:)];	// set the action
    [fontPopup setTarget:self];			// set the target
    [fontPopup setAction:@selector(set:)];	// set the action

    [self update:self];

    return self;
}

- (NSImage*)icon
{   NSImage	*icon = nil;

    if (!icon)
    {   NSBundle	*bundle = [NSBundle bundleForClass:[self class]];
        NSString	*file = [bundle pathForResource:@"prefsAstro" ofType:@"tiff"];

        icon = [[NSImage alloc] initWithContentsOfFile:file];
    }
    return icon;
}

- (NSString*)name
{
    return @"Astro";
}

- (NSView*)view
{
    return box;
}

// end methods from protocol

- (void)update:sender
{   id		defaults = [NSUserDefaults standardUserDefaults];
    int		i;
    NSArray	*objects, *nodes, *objects1 = OBJECTS_1, *objects2 = OBJECTS_2;

    [[switchMatrix cellAtRow:SWITCH_SHOWRETROGRADE column:0]
      setState:([[defaults objectForKey:@"astroShowRetrograde"] isEqual:@"YES"]) ? 1 : 0];
    [[switchMatrix cellAtRow:SWITCH_LOCALSCALE column:0]
      setState:([[defaults objectForKey:@"astroLocalScale"] isEqual:@"YES"]) ? 1 : 0];
    [[switchMatrix cellAtRow:SWITCH_TOPOCENTRIC column:0]
      setState:([[defaults objectForKey:@"astroTopocentricPosition"] isEqual:@"YES"]) ? 1 : 0];
    [[switchMatrix cellAtRow:SWITCH_SHOWDECLINATION column:0]
      setState:([[defaults objectForKey:@"astroShowDeclination"] isEqual:@"YES"]) ? 1 : 0];
    [[switchMatrix cellAtRow:SWITCH_ACFIX column:0]
      setState:([[defaults objectForKey:@"astroACFix"] isEqual:@"YES"]) ? 1 : 0];
    [[switchMatrix cellAtRow:SWITCH_MEANNODES column:0]
      setState:([[defaults objectForKey:@"astroMeanNodes"] isEqual:@"YES"]) ? 1 : 0];
    [[switchMatrix cellAtRow:SWITCH_DEGREESMINUTES column:0]
      setState:([[defaults objectForKey:@"astroDegreesMinutes"] isEqual:@"YES"]) ? 1 : 0];
    [[switchMatrix cellAtRow:SWITCH_COLORFUL column:0]
      setState:([[defaults objectForKey:@"astroColorful"] isEqual:@"YES"]) ? 1 : 0];

    if ( [[defaults objectForKey:@"astroDateFormat"] isEqual:@"%d.%m.%Y"] )
        [datePopup selectItemAtIndex:0];
    else
        [datePopup selectItemAtIndex:1];

    [fontPopup selectItemWithTitle:[defaults objectForKey:@"astroFont"]];
    /* GNUstep: workaround for uninitialized popup menus (they start with selected item = -1) */
#ifdef GNUSTEP_BASE_VERSION
    if ([fontPopup indexOfSelectedItem] == -1)
        [fontPopup selectItemAtIndex:0];
#endif

    /* set object switches */
    objects = [defaults objectForKey:@"astroObjects"];
    for (i=0; i<(int)[objects1 count]; i++)	// planets
    {
        [[object1Switches cellAtRow:i column:0]
             setState:[objects containsObject:[objects1 objectAtIndex:i]]];
    }
    nodes = [defaults objectForKey:@"astroNodes"];
    for (i=0; i<(int)[objects1 count]; i++)	// nodes
    {
        [[nodeSwitches cellAtRow:i column:0]
             setState:[nodes containsObject:[objects1 objectAtIndex:i]]];
    }
    for (i=0; i<(int)[objects2 count]; i++)	// other objects
    {
        [[object2Switches cellAtRow:i column:0]
             setState:[objects containsObject:[objects2 objectAtIndex:i]]];
    }

    [bgColorWell setColor:vhfRGBColorFromString([defaults objectForKey:@"astroBGColor"])];
}


- (void)set:sender
{   NSString	*string;
    NSColor	*color;
    id		defaults = [NSUserDefaults standardUserDefaults];
    int		i;

    //    [[NSNotificationCenter defaultCenter] postNotificationName:PrefsAllLayersHaveChanged
    //                                                        object:nil userInfo:nil];

    /* show retrograde directions */
    string = ([[switchMatrix cellAtRow:SWITCH_SHOWRETROGRADE column:0] state]) ? @"YES" : @"NO";
    if ( ![string isEqual:[defaults objectForKey:@"astroShowRetrograde"]] )
    	[defaults setObject:string forKey:@"astroShowRetrograde"];
    /* locale scale */
    string = ([[switchMatrix cellAtRow:SWITCH_LOCALSCALE column:0] state]) ? @"YES" : @"NO";
    if ( ![string isEqual:[defaults objectForKey:@"astroLocalScale"]] )
    	[defaults setObject:string forKey:@"astroLocalScale"];
    /* topocentric planet position */
    string = ([[switchMatrix cellAtRow:SWITCH_TOPOCENTRIC column:0] state]) ? @"YES" : @"NO";
    if ( ![string isEqual:[defaults objectForKey:@"astroTopocentricPosition"]] )
    	[defaults setObject:string forKey:@"astroTopocentricPosition"];
    /* Declination */
    string = ([[switchMatrix cellAtRow:SWITCH_SHOWDECLINATION column:0] state]) ? @"YES" : @"NO";
    if ( ![string isEqual:[defaults objectForKey:@"astroShowDeclination"]] )
    	[defaults setObject:string forKey:@"astroShowDeclination"];
    /* AC fix */
    string = ([[switchMatrix cellAtRow:SWITCH_ACFIX column:0] state]) ? @"YES" : @"NO";
    if ( ![string isEqual:[defaults objectForKey:@"astroACFix"]] )
    	[defaults setObject:string forKey:@"astroACFix"];
    /* display mean nodes */
    string = ([[switchMatrix cellAtRow:SWITCH_MEANNODES column:0] state]) ? @"YES" : @"NO";
    if ( ![string isEqual:[defaults objectForKey:@"astroMeanNodes"]] )
    	[defaults setObject:string forKey:@"astroMeanNodes"];
    /* show degrees with minutes */
    string = ([[switchMatrix cellAtRow:SWITCH_DEGREESMINUTES column:0] state]) ? @"YES" : @"NO";
    if ( ![string isEqual:[defaults objectForKey:@"astroDegreesMinutes"]] )
    	[defaults setObject:string forKey:@"astroDegreesMinutes"];
    /* make colorful */
    string = ([[switchMatrix cellAtRow:SWITCH_COLORFUL column:0] state]) ? @"YES" : @"NO";
    if ( ![string isEqual:[defaults objectForKey:@"astroColorful"]] )
    	[defaults setObject:string forKey:@"astroColorful"];

    /* background color */
    color = [bgColorWell color];
    if ( ![color isEqual:vhfRGBColorFromString([defaults objectForKey:@"astroBGColor"])] )
    	[defaults setObject:vhfStringFromRGBColor(color) forKey:@"astroBGColor"];

    /* date format */
    i = [datePopup indexOfSelectedItem];
    if ( !i && ![[defaults objectForKey:@"dateFormat"] isEqual:@"%d.%m.%Y"] )
    	[defaults setObject:@"%d.%m.%Y" forKey:@"astroDateFormat"];
    else if (i && ![[defaults objectForKey:@"dateFormat"] isEqual:@"%Y-%m-%d"])
    	[defaults setObject:@"%Y-%m-%d" forKey:@"astroDateFormat"];

    /* font */
    string = [fontPopup titleOfSelectedItem];
    if ( ![string isEqual:[defaults objectForKey:@"astroFont"]] )
    	[defaults setObject:string forKey:@"astroFont"];

    /* write names of active objects */
    {   int		i;
        NSArray		*objects1, *objects2;
        NSMutableArray	*objects = [NSMutableArray array], *nodes = [NSMutableArray array];

        objects1 = OBJECTS_1;
        for (i=0; i<(int)[objects1 count]; i++)	// planets
            if ([[object1Switches cellAtRow:i column:0] state])
                [objects addObject:[objects1 objectAtIndex:i]];

        for (i=0; i<(int)[objects1 count]; i++)	// nodes
            if ([[nodeSwitches cellAtRow:i column:0] state])
                [nodes addObject:[objects1 objectAtIndex:i]];
        [defaults setObject:nodes forKey:@"astroNodes"];

        objects2 = OBJECTS_2;
        for (i=0; i<(int)[objects2 count]; i++)	// moon nodes, asteroids
            if ([[object2Switches cellAtRow:i column:0] state])
                [objects addObject:[objects2 objectAtIndex:i]];
        [defaults setObject:objects forKey:@"astroObjects"];
    }

    /* show maximum positions of houses */
    //string = ([[switchMatrix cellAtRow:SWITCH_SHOWHOUSEMAXIMA column:0] state]) ? @"YES" : @"NO";
    //if ( ![string isEqual:[defaults objectForKey:@"showHouseMaxima"]] )
    //	[defaults setObject:string forKey:@"showHouseMaxima"];
}

/* set background color
 */
/*- (void)setColor:sender
{
    color = [bgColorWell color];
    if ( ![color isEqual:vhfRGBColorFromString([defaults objectForKey:@"astroBGColor"])] )
    	[defaults setObject:vhfStringFromRGBColor(color) forKey:@"astroBGColor"];
}*/

@end
