#
# Build tar.gz Archive of Sources
#
# Author:   Georg Fleischmann
# modified: 2003-02-28
#

PROJECTS=~/Projects
LIBRARIES=$PROJECTS/Libraries	# the directory above the Source and Ship folders
TAR_DIR=$LIBRARIES/Ship
NAME=VHFShared

#
# link name of Sourcefolder to source folder
#

cd $LIBRARIES
#ln -s VHFShared $NAME


#
# copy change-logs and tiffs to folders
#

cd $LIBRARIES/$NAME
cp *-*.txt ./ChangeLog/


#
# create tar archive
# we use the h option to collect the links too
#
cd $LIBRARIES
gnutar	cvh -f $TAR_DIR/$NAME.tar -X $NAME/sourceTAR.exclude \
	$NAME/*.h $NAME/*.m $NAME/*.c \
	$NAME/*Makefile* $NAME/PB* \
	$NAME/.*dir.tiff \
	$NAME/*.sh \
	$NAME/ChangeLog \
	$NAME/DB

#
# compress
#

cd $TAR_DIR
gzip -f $TAR_DIR/$NAME.tar
