#!/bin/sh
#
# Convert special characters of gmodel files from OpenStep to GNUstep
#
# by Georg Fleischmann
# modified: 2002-10-19
#

echo '***' convert special characters in $1 '***'

cd $1

for lng in English German
do

    # convert special characters
    # ae  \331 \U00e4
    # oe  \360 \U00f6
    # ue  \366 \U00fc
    # Ae  \205 \U00c4
    # Oe  \226 \U00d6
    # Ue  \232 \U00dc
    # ss  \373 \U00df
    # ... \274 ...
    # deg \312 \U00b0

    for FILE in $lng.lproj/*.gmodel */$lng.lproj/*.gmodel */*/$lng.lproj/*.gmodel
    do
        if [ -f $FILE ]; then
          echo $FILE
          sed -e 's/\\331/\\U00e4/g' -e 's/\\360/\\U00f6/g' -e 's/\\366/\\U00fc/g' \
              -e 's/\\205/\\U00c4/g' -e 's/\\226/\\U00d6/g' -e 's/\\232/\\U00dc/g' \
              -e 's/\\373/\\U00df/g' -e 's/\\312/\\U00b0/g' -e 's/\\274/.../g' ${FILE} > ${FILE}.tmp
          mv $FILE.tmp $FILE
        fi
    done

    #STR="te373st\373"
    #echo $STR
    #echo echo ${STR} | sed -e 's/\\\373/\\\U00df/g'`

done
