#
# OpenStep: Convert nib to gmodel files
# - temporary link images into nib files as needed
# - convert nib files to gmodel files
# - call 'Convertgmodels.sh' to correct gmodel files (class names etc.)
# - call 'Convertgmodels1.sh' to convert special characters
#
# Author:   Georg Fleischmann
# modified: 2008-12-09
#

CENON=`echo $0 | sed -e 's|Nib2gmodel.sh||'`
PROJECTS=$HOME/Projects
#CENON=$PROJECTS/Cenon/Source/Cenon

cd $CENON

echo ToolPanel.nib
nib2gmodel ToolPanel.nib ToolPanel.gmodel
echo Info.nib
nib2gmodel Info.nib Info.gmodel

for lng in English German
do

    for nib in Contour Document GridPanel LayerDetails Main PageLayoutAccessory \
               PrintPanelAccessory TilePanel WorkingAreaPanel IntersectionPanel
    do
        echo $lng.lproj/$nib.nib
        nib2gmodel $lng.lproj/$nib.nib $lng.lproj/$nib.gmodel
    done

    # InspectorPanel
    for nib in InspectorPanel IPAllFilling IPAllLayers IPAllStrokeWidth IPAllAcc IPAccText \
	       IPArc IPCrosshairs IPCurve IPGroup IPImage IPLine IPLine3D IPPolyLine IPMark \
	       IPPath IPRectangle IPThread IPText IPTextPath IPWeb IPSinking
    do
        echo InspectorPanel.subproj/$lng.lproj/$nib.nib
        ln -s $CENON/arrow*.tiff InspectorPanel.subproj/$lng.lproj/$nib.nib/
        nib2gmodel InspectorPanel.subproj/$lng.lproj/$nib.nib InspectorPanel.subproj/$lng.lproj/$nib.gmodel
        rm InspectorPanel.subproj/$lng.lproj/$nib.nib/arrow*.tiff
    done

    # PreferencesPanel + Bundles
    for nib in PreferencesPanel
    do
        FILE=PreferencesPanel.subproj/$lng.lproj/$nib
        if [ -d $FILE.nib ]; then
          echo $FILE.nib
          nib2gmodel $FILE.nib $FILE.gmodel
        fi
    done
    for nib in General Import Export DTP PCB
    do
        FILE=PreferencesPanel.subproj/$nib.bproj/$lng.lproj/$nib
        if [ -d $FILE.nib ]; then
          echo $FILE.nib
          nib2gmodel $FILE.nib $FILE.gmodel
        fi
    done

    # ProjectSettingsPanel
    for nib in ProjectSettingsPanel PSInfo PSSettings
    do
        echo ProjectSettingsPanel.subproj/$lng.lproj/$nib.nib
        nib2gmodel ProjectSettingsPanel.subproj/$lng.lproj/$nib.nib ProjectSettingsPanel.subproj/$lng.lproj/$nib.gmodel
    done

    # TransformPanel
    for nib in TransformPanel TPAlign TPMix TPScale TPMove TPRotate
    do
        ln -s $CENON/tp*.tiff TransformPanel.subproj/$lng.lproj/$nib.nib/
        echo TransformPanel.subproj/$lng.lproj/$nib.nib
        nib2gmodel TransformPanel.subproj/$lng.lproj/$nib.nib TransformPanel.subproj/$lng.lproj/$nib.gmodel
        rm TransformPanel.subproj/$lng.lproj/$nib.nib/tp*.tiff
    done

done

# modify dictionary entries
echo
echo Correct entries from property list
echo
cd $CENON
$PROJECTS/Linux/GNUstep/convertgmodels/convertgmodels $CENON/nib2gmodel.plist

# convert special characters
echo
echo Convert special characters
echo
cd $CENON
./nib2gmodel_chars.sh $CENON
